/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SeekableByteArrayOutputStream
extends ByteArrayOutputStream {
    protected int maxCount;

    public SeekableByteArrayOutputStream() {
    }

    public SeekableByteArrayOutputStream(int size) {
        super(size);
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.maxCount = 0;
    }

    @Override
    public int size() {
        if (this.count > this.maxCount) {
            return this.count;
        }
        return this.maxCount;
    }

    @Override
    public synchronized byte[] toByteArray() {
        int c = this.count;
        if (this.count > this.maxCount) {
            this.maxCount = this.count;
        } else {
            this.count = this.maxCount;
        }
        byte[] ba = super.toByteArray();
        this.count = c;
        return ba;
    }

    public synchronized void seek(long pos) throws IOException {
        if (this.count > this.maxCount) {
            this.maxCount = this.count;
        }
        if (pos > (long)this.maxCount) {
            throw new IllegalArgumentException("Cannot seek past end of written data: seek=" + pos + ", pos=" + pos + " of " + this.maxCount);
        }
        this.count = (int)pos;
    }

    public synchronized long tell() throws IOException {
        return this.count;
    }
}

